using System;
using Server;
using Server.Items;

namespace Server.Mobiles
{
	//[CorpseName( "a chief paroxysmus corpse" )]
	public class ChiefParoxysmus: BaseCreature
	{
		private bool m_SpawnBulbous;
		private DateTime m_Delay = DateTime.Now;
		private bool IsMLBoss;
		
      [Constructable]
		public ChiefParoxysmus() : this ( true )
		{
		}
		
      [Constructable]
		public ChiefParoxysmus( bool ismlboss ) : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			IsMLBoss = ismlboss;
         Name = "a chief paroxysmus";
			Body = 0x100;

			SetStr( 1232, 1400 );
			SetDex( 86, 92 );
			SetInt( 76, 85 );

			SetHits( 10000 );

			SetDamage( 19, 39 );

			SetDamageType( ResistanceType.Physical, 80 );
			SetDamageType( ResistanceType.Poison, 20 );

			SetResistance( ResistanceType.Physical, 75, 85 );
			SetResistance( ResistanceType.Fire, 40, 50 );
			SetResistance( ResistanceType.Cold, 40, 60 );
			SetResistance( ResistanceType.Poison, 50, 65 );
			SetResistance( ResistanceType.Energy, 50, 60 );
			
			SetSkill( SkillName.Wrestling, 130.0 );
			SetSkill( SkillName.Tactics, 130.0 );
			SetSkill( SkillName.MagicResist, 130.0 );
			SetSkill( SkillName.Anatomy, 120.0 );
			SetSkill( SkillName.Poisoning, 130.0 );

			Fame = 24000;
			Karma = -10000;
			VirtualArmor = 100;
			
			PackItem( new RandomTalisman() );
			PackItem( new Tokens( Utility.RandomMinMax( 25, 45 ) ) );
		}
		
		public ChiefParoxysmus( Serial serial ) : base( serial )
		{
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.AosSuperBoss, 2 );
			AddLoot( LootPack.AosUltraRich, 3 );
			AddLoot( LootPack.AosFilthyRich, 2 );
		}
		
		public override void OnDeath( Container c )
		{
			base.OnDeath( c );
         
			if ( IsMLBoss )
			{
				c.DropItem( new LardOfParoxysmus() );
				c.DropItem( Loot.RandomArcanistScroll() );
				
    			switch ( Utility.Random( 3 ) )
    			{
    				case 0: c.DropItem( new ParoxysmusDinner() ); break;
    				case 1: c.DropItem( new ParoxysmusCorrodedStein() ); break;
    				case 2: c.DropItem( new StringOfPartsOfParoxysmusVictims() ); break;
    			}
    			
    		
    			if ( Utility.RandomBool() )
    				c.DropItem( new SweatOfParoxysmus() );
         }
	
// 			if ( Utility.RandomDouble() < 0.05 )
// 				c.DropItem( new ParoxysmusSwampDragonStatuette() );
				
			if ( Utility.RandomDouble() < 0.05 )
				c.DropItem( new ScepterOfTheChief() );
				
			if ( Utility.RandomDouble() < 0.02 )
				c.DropItem( new CrimsonCinture() );
		}

		
		public override Poison PoisonImmune{ get{ return Poison.Lethal; } }		
		public override Poison HitPoison{ get{ return Poison.Deadly; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		public override bool BardImmune{ get{ return true; } }
		public override bool Unprovokable{ get{ return true; } }
		public override bool Uncalmable{ get{ return true; } }
// 		public override bool CanAreaPoison{ get{ return true; } }
// 		public override Poison HitAreaPoison{ get{ return Poison.Lethal; } }
		
		public override int GetDeathSound()	{ return 0x56F; }
		public override int GetAttackSound() { return 0x570; }
		public override int GetIdleSound() { return 0x571; }
		public override int GetAngerSound() { return 0x572; }
		public override int GetHurtSound() { return 0x573; }

		public override void OnDamage( int amount, Mobile from, bool willKill, int typ )
		{
			base.OnDamage( amount, from, willKill, typ );
			
			if ( IsMLBoss && !m_SpawnBulbous )
			{
            SpawnBulbous();
            m_SpawnBulbous = true;
         }
         
			if ( DateTime.Now > m_Delay )
			{
				Ability.Aura( this, 60, 70, 3, 6, 4, this.Name + " vyvolal oblak jedovateho plynu.", true );
				m_Delay = DateTime.Now + TimeSpan.FromSeconds( Utility.RandomMinMax( 20, 40 ) );
			}
         
//          // eats pet or summons
			if ( from is BaseCreature )
			{
				BaseCreature creature = (BaseCreature) from;
				
				if ( creature.Controlled || creature.Summoned )
				{
					creature.Kill();				
					
					Effects.PlaySound( Location, Map, 0x574 );
				}
			}
			
			// teleports player near
			if ( from is PlayerMobile && !InRange( from.Location, 1 ) && Utility.RandomDouble() < 0.1 )
			{
				Combatant = from;
				
				from.MoveToWorld( Location, Map );				
				from.FixedParticles( 0x376A, 9, 32, 0x13AF, EffectLayer.Waist );
				from.PlaySound( 0x1FE );
			}
		}
		
		public override void OnKilledBy( Mobile mob )
		{
			base.OnKilledBy( mob );

			if ( IsMLBoss && Paragon.CheckArtifactChance( mob, this ) )
			{
				Paragon.GiveMLArtifactTo( mob );
			}
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			
			int version = reader.ReadInt();
		}
		
		public virtual void SpawnBulbous()
		{
			for ( int i = 0; i < 3; i ++ )
			{
				Mobile blobus = new BulbousPutrification();
				blobus.MoveToWorld( Location, Map );
			}
		}
	}
}
